/***********************************************************************
 *
 *  Copyright (c) 2005-2010  Broadcom Corporation
 *  All Rights Reserved
 *
<:label-BRCM:2011:proprietary:standard

 This program is the proprietary software of Broadcom Corporation and/or its
 licensors, and may only be used, duplicated, modified or distributed pursuant
 to the terms and conditions of a separate, written license agreement executed
 between you and Broadcom (an "Authorized License").  Except as set forth in
 an Authorized License, Broadcom grants no license (express or implied), right
 to use, or waiver of any kind with respect to the Software, and Broadcom
 expressly reserves all rights in and to the Software and all intellectual
 property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE
 NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY
 BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.

 Except as expressly set forth in the Authorized License,

 1. This program, including its structure, sequence and organization,
    constitutes the valuable trade secrets of Broadcom, and you shall use
    all reasonable efforts to protect the confidentiality thereof, and to
    use this information only in connection with your use of Broadcom
    integrated circuit products.

 2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
    AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
    WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
    RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND
    ALL IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT,
    FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
    COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE
    TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF USE OR
    PERFORMANCE OF THE SOFTWARE.

 3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR
    ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
    INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY
    WAY RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN
    IF BROADCOM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES;
    OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE
    SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE LIMITATIONS
    SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF ANY
    LIMITED REMEDY.
:>
 *
************************************************************************/

#ifndef L2_DRIVER_QOS_H
#define L2_DRIVER_QOS_H

// Interface Dependencies --------------------------------------------
#include "base_types.h"
#include "transactions/definitions.h"
// END Interface Dependencies ----------------------------------------
/**
   \brief Classifier rules currently defined.
*/
typedef enum
{
   CLASSIF_RULE_ETH_DA = 0, //!< Destination Address of the Ethernet frame.
   CLASSIF_RULE_ETH_SA, //!< Source Address of the Ethernet frame.
   CLASSIF_RULE_VLAN_PRIORITY, //!< VLAN User Priority
   CLASSIF_RULE_VLAN_ID, //!< VLAN ID
   CLASSIF_RULE_IPV4_TOS, //!< IPv4 Type of Service
   CLASSIF_RULE_IPV4_PROT, //!< IPv4 Protocol
   CLASSIF_RULE_IPV4_SA, //!< IPv4 Source Address
   CLASSIF_RULE_IPV4_DA, //!< IPv4 Destination Address
   CLASSIF_RULE_IPV6_TRAF_CLASS, //!< IPv6 Traffic Class
   CLASSIF_RULE_IPV6_FLOW_LABEL, //!< IPv6 Flow Label
   CLASSIF_RULE_IPV6_SA, //!< IPv6 Source Address
   CLASSIF_RULE_IPV6_DA, //!< IPv6 Destination Address
   CLASSIF_RULE_TCP_SPORT, //!< TCP Source Port
   CLASSIF_RULE_TCP_DPORT, //!< TCP Destination Port
   CLASSIF_RULE_UDP_SPORT, //!< UDP Source Port
   CLASSIF_RULE_UDP_DPORT, //!< UDP Destination Port
   CLASSIF_RULE_MCAST_ADDR_IPv4, //!< Multicast address IPv4
   CLASSIF_RULE_MCAST_ADDR_IPv6,  //!< Multicast address IPv4
   CLASSIF_RULE_IPV4_DSCP, //!< Differenciated services
   CLASSIF_RULE_MCAST_ADDR_IPv4_MANAGED, /**< Multicast MAC address IPV4 managed */
   CLASSIF_RULE_MCAST_ADDR_IPv6_MANAGED, /**< Multicast MAC address IPV6 managed */
   CLASSIF_RULE_UCAST_ADDR, /**< Unicast address */
   CLASSIF_RULE_MCAST_ADDR_IPv4_UNMANAGED, /**<  Multicast MAC address IPV4 unmanaged */
   CLASSIF_RULE_MCAST_ADDR_IPv6_UNMANAGED, /**<  Multicast MAC address IPV6 unmanaged */
   CLASSIF_RULE_IGMP, /**<  Multicast IGMP (mcast addr and IPV4 proto IGMP) */
   CLASSIF_RULE_INVALID = 0XFF   //!< Invalid / uninitialized
}
tE_ClassifierRule;

/**
   \brief Classifier rules types
*/
typedef enum
{
   NUMBER,
   ETH_ADD,
   IPv4_ADDR,
   IPv6_ADDR,
   MCAST_ADDR_IPV4,
   MCAST_ADDR_IPV6
} tE_ClassifierRuleType;

/** 
   \brief Channel Access Priority.
*/
typedef enum
{
   CAP_0 = 0,
   CAP_1,
   CAP_2,
   CAP_3
} tE_CAP;

/** 
   \brief Classifier rule for no_diag.
*/
typedef struct
{
   tE_ClassifierRule id; //!< rule id
   TU8 value_size; //!< value size
   TU8 value[16]; //!< value
} tS_ClassifierRuleNoDiag;

/** 
   \brief Classifier rule set
*/
typedef struct
{
   TU8 no_av_rules; //!< Number of chaining rules (a maximum of 4)
   tE_ClassifierRule id[4]; //!< rule's ids

   TU8 no_bytes_used; //!< Number of bytes used in the rule value buffer
   TU8 value[16]; /*!< rules value buffer
                       (all the rules shared 16 bytes for their value) */
} tS_ClassifierRuleSetNoDiag;


/**
   \brief QoS rule
*/
typedef struct st_QoSRuleNoDiag tS_QoSRuleNoDiag;
struct st_QoSRuleNoDiag
{
   tE_CAP CAP; //!< QoS rule channel access priority.
   tS_ClassifierRuleSetNoDiag classifier_rule_set; //!< classifier rules assoc.
};

/** 
   \brief Exit code once the classifier rules and its associated CSPEC data
          are changed in the NV-RAM
*/
typedef enum
{
  L2API_ECODE_SETQOS_NORULES = 0, //!< Number of QoS rules to set is 0
  L2API_ECODE_SETQOS_RULESNULL, //!< QoS rules to set are NULL
  L2API_ECODE_SETQOS_MAXRULES, //!< Number of QoS rules to set greater than MAX
  L2API_ECODE_SETQOS_GETPARAM1, //!< Error get val for param CLASSIFIER_RULES_SRC_DST_MAC
  L2API_ECODE_SETQOS_GETPARAM2, //!< Error get val for param CLASSIFIER_RULES_VLAN
  L2API_ECODE_SETQOS_GETPARAM3, //!< Error get val for param CLASSIFIER_RULES_IP_TOS_PROT
  L2API_ECODE_SETQOS_GETPARAM4, //!< Error get val for param CLASSIFIER_RULES_IP_DST_SRC_ADDR
  L2API_ECODE_SETQOS_GETPARAM5, //!< Error get val for param CLASSIFIER_RULES_UDP_TCP_PORT
  L2API_ECODE_SETQOS_MAXTYPERULES1, /*!< Number of RULES_SRC_DST_MAC greater than
                                         val for param CLASSIFIER_RULES_SRC_DST_MAC */
  L2API_ECODE_SETQOS_MAXTYPERULES2, /*!< Number of VLAN greater than
                                         val for param CLASSIFIER_RULES_VLAN */
  L2API_ECODE_SETQOS_MAXTYPERULES3, /*!< Number of IP_TOS_PROT greater than
                                         val for param CLASSIFIER_RULES_IP_TOS_PROT */
  L2API_ECODE_SETQOS_MAXTYPERULES4, /*!< Number of IP_DST_SRC_ADDR greater than
                                         val for param CLASSIFIER_RULES_IP_DST_SRC_ADDR */
  L2API_ECODE_SETQOS_MAXTYPERULES5, /*!< Number of UDP_TCP_PORT greater than
                                         val for param CLASSIFIER_RULES_UDP_TCP_PORT */
  L2API_ECODE_SETQOS_SUCCESS, //!< Data set successfully
  L2API_ECODE_SETQOS_FAIL //!< Data didn't set successfully

} tE_SetQoSRulesResult;

/** 
   \brief Type of paramconfig supporting QoS parameter
*/
typedef enum
{
  L2API_QOS_PARAMCONFIG_ONLY_USER, /* paramconfig has only user param */
  L2API_QOS_PARAMCONFIG_USER_MANUFACTURER, /* paramconfig has both params*/
} tE_l2driver_QoS_ParamConfigType;

/** 
   \brief QoS parameter selected (paramconfig and parameter id)
*/
typedef struct
{
  tE_l2driver_QoS_ParamConfigType paramconfigType;
  TU16 param;
} tS_l2driver_QoS_ParameterSel; 

/**
   \brief   Remove all the Classifier rules and its associated CSPEC data in the
            NV-RAM.
   \note    You must reboot the device for the changes to take effect.
   \return  TRUE if the data was cleared successfully otherwise return FALSE.
*/

TBool l2driver_ClearQoSRules(
  const tS_l2driver_QoS_ParameterSel*);

/**
   \brief   Parse QoS rules struct and fill the output raw buffer
   
   \param   
   \param   no_rules  - Number of QoS rules to set.
   \param   qos_rules - QoS rules to set. A maximum of 12 are allowed.
   \param   nvram     - Output buffer
   \return  tE_SetQoSRulesResult with exit code.
*/

tE_SetQoSRulesResult l2driver_WriteDataNVRAM(
   const tS_l2driver_QoS_ParameterSel* paramSel,
   const TU8 no_rules,
   const tS_QoSRuleNoDiag *qos_rules,
   TU8* nvram);
   
/**
   \brief   Change the Classifier rules and its associated CSPEC data in the
            NV-RAM.
   \note    You must reboot the device for the changes to take effect.
   
   \param   
   \param   no_rules - Number of QoS rules to set.
   \param   qos_rules - QoS rules to set. A maximum of 12 are allowed.
   \return  tE_SetQoSRulesResult with exit code.
*/

tE_SetQoSRulesResult l2driver_SetQoSRules(
   const tS_l2driver_QoS_ParameterSel* paramSel,
   const TU8 no_rules,
   const tS_QoSRuleNoDiag *qos_rules);

/**
   \brief   Obtain the QoS rules saved within the NV-RAM.
   
   \param
   \param   no_rules - number of rules obtained.
   \param   qos_rules - QoS rules obtained.
   \return  TRUE if the rules were obtained successfully otherwise return FALSE.
*/

TBool l2driver_GetQoSRules(
   const tS_l2driver_QoS_ParameterSel* paramSel,
   TU8* no_rules,
   tS_QoSRuleNoDiag *qos_rules);

/**
   \brief Read Classifier rules and its associated CSPEC from NV-RAM
*/
TBool l2driver_ReadDataNVRAM(
  const tS_l2driver_QoS_ParameterSel* paramSel,
  const TU8* nvram,
  TU8* no_rules,
  tS_QoSRuleNoDiag* qos_rules);

  
/**
   \brief   Extract from a Classifier Rule Set the single Classifier Rules
   \param   rule_set - Rule set
   \param   rules - array with the individual rules extracted from the rule set
*/
void l2driver_ExtractClassifRule(
   const tS_ClassifierRuleSetNoDiag rule_set,
   tS_ClassifierRuleNoDiag* rules);
  
/**
   \brief Returns size in octets for a classifier rule
   \param   classif_rule   rule
   \return  TU8            classifier rule size
*/
TU8 l2driver_classifier_size(const tE_ClassifierRule classif_rule);

/**
   \brief Get rule type
   \param   rule                    rule
   \return  tE_ClassifierRuleType   rule type
*/
tE_ClassifierRuleType l2driver_classifier_type(const tE_ClassifierRule rule);

#endif // L2_DRIVER_QOS_H

